﻿using System;
using System.Windows.Forms;
using System.Drawing;
using System.Drawing.Drawing2D;

namespace CSharpBuch.Kap24
{
  class Aufgabe1
  {
    [STAThread]
    static void Main()
    {
      Application.EnableVisualStyles();
      Application.Run(new Form1());
    }
  }

  public class Form1:Form
  {
    public Form1()
    {
      this.ClientSize = new Size(280, 200);
      this.BackColor = Color.White;
      this.Text = "Grafik anzeigen";
    }

    protected override void OnPaint(PaintEventArgs e)
    {
      base.OnPaint(e);
      Graphics g = e.Graphics;
      Pen pen = new Pen(Color.Blue, 2);
      Rectangle r1 = new Rectangle(20, 20, 80, 160);
      g.DrawRectangle(pen, r1);

      // Ellipse im Rechteck
      Rectangle r2 = new Rectangle(25, 25, 70, 70);
      g.FillEllipse(Brushes.LightGreen, r2);

      Point[] ps = { new Point(25, 100), new Point(25, 176), new Point(95, 138) };
      g.FillPolygon(Brushes.Goldenrod, ps);

      g.DrawLine(Pens.Black, new Point(140, 10), new Point(140, 190));

      g.TranslateTransform(280, 200);
      g.RotateTransform(180);
      g.DrawRectangle(pen, r1);
      g.FillEllipse(Brushes.LightGreen, r2);
      g.FillPolygon(Brushes.Goldenrod, ps);
    }
  }
}